<%@ Import Namespace="System.Web.Services" %>
<%@ Import Namespace="AjaxControlToolkit" %>
<%@ Register Assembly="AjaxControlToolkit"
    Namespace="AjaxControlToolkit" TagPrefix="asp" %>

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">

<script runat="server" language="C#">

   [WebMethod]
   [System.Web.Script.Services.ScriptMethod]
   public static CascadingDropDownNameValue[]
      GetStates(string knownCategoryValues, string category)
   {
      return new[] {
   new CascadingDropDownNameValue("Maopolskie", "Maopolskie"),
   new CascadingDropDownNameValue("Mazowieckie", "Mazowieckie") };
   }

   [WebMethod]
   [System.Web.Script.Services.ScriptMethod]
   public static CascadingDropDownNameValue[]
      GetCounties(string knownCategoryValues, string category)
   {
      if (knownCategoryValues.Contains("Maopolskie"))
      {
         return new[] {
            new CascadingDropDownNameValue("Krakw",
             "Krakw"),
            new CascadingDropDownNameValue("Nowy Targ",
             "Nowy Targ"),
            new CascadingDropDownNameValue("Wadowice",
             "Wadowice"),
            new CascadingDropDownNameValue("Zakopane", "Zakopane"),
            new CascadingDropDownNameValue("Owicim",
             "Owicim") };
      }
      if (knownCategoryValues.Contains("Mazowieckie"))
      {
         return new[] {
            new CascadingDropDownNameValue("Warszawa", "Warszawa"),
            new CascadingDropDownNameValue("Ostroka", "Ostroka"),
            new CascadingDropDownNameValue("Pock",
             "Pock"),
            new CascadingDropDownNameValue("Radom",
             "Radom"),
            new CascadingDropDownNameValue("Siedlce",
             "Siedlce") };
      }
      return null;
   }

</script>

    <title>CascadingDropDown</title>
</head>
<body>
    <form id="form1" runat="server">
    <asp:ToolkitScriptManager runat="server" ID="scriptManager" />
    <div>
        <asp:DropDownList runat="server" ID="ddl1" Width="200" />
        <br />
        <asp:DropDownList runat="server" ID="ddl2" Width="200" />
        <br />
        <asp:CascadingDropDown runat="server" ID="cdd1" TargetControlID="ddl1" 
            PromptText="Select a State"
            Category="state" LoadingText="[Wczytywanie wojewdztw]" 
            ServiceMethod="GetStates" />
        <asp:CascadingDropDown runat="server" ID="cdd2" TargetControlID="ddl2" 
            ParentControlID="ddl1"
            PromptText="Select County" Category="county" 
            LoadingText="[Wczytywanie powiatw]"
            ServiceMethod="GetCounties" />
    </div>
    </form>
</body>
</html>
